<?php

namespace App\Http\Controllers\dashboard\user;

use App\Http\Controllers\Controller;
use App\Http\Requests\UpdateUserProfileRequest;
use App\Services\user\UserProfileService;
use App\Services\user\UserLoginService;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\JsonResponse;

class UserProfileController extends Controller
{
    protected $userProfileService;
     protected $userLoginService;

    public function __construct(UserProfileService $userProfileService,UserLoginService $userLoginService)
    {
        $this->userProfileService = $userProfileService;
        $this->userLoginService = $userLoginService;
    }

    public function update(UpdateUserProfileRequest $request): JsonResponse
    {
        $user = Auth::user();

        $data = $request->validated();

        $result = $this->userProfileService->updateProfile($user->id, $data);

        if ($result['status'] === 'error') {
            return response()->json(['status' => 'error', 'message' => $result['message']], 422);
        }

        return response()->json(['status' => 'success', 'message' => $result['message'], 'data' => $result['data']]);
    }


    public function loginLists()
    {
        $user = Auth::user();
        $logins = $this->userLoginService->getUserLogins($user->id);

        return response()->json(['data' => $logins]);
    }

    public function logoutOthers(Request $request)
    {
        $user = Auth::user();

        $currentLoginId = $request->input('current_login_id');
        if (!$currentLoginId) {
            return response()->json(['message' => 'شناسه لاگین فعلی ارسال نشده'], 422);
        }

        $this->userLoginService->logoutOtherDevices($user->id, $currentLoginId);

        return response()->json(['message' => 'دستگاه‌های دیگر با موفقیت خارج شدند']);
    }
}
