<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphOne;
use Illuminate\Database\Eloquent\Relations\HasOne;

class Category extends Model
{
    protected $fillable = [
        'name',
        'slug',
        'description',
        'parent_id',
        'is_active',
        'sort_order'
    ];

    // رابطه والد (parent)
    public function parent(): BelongsTo
    {
        return $this->belongsTo(Category::class, 'parent_id');
    }

    // رابطه آیتم‌ها
    public function items(): HasMany
    {
        return $this->hasMany(Item::class);
    }

    // رابطه فیلدهای داینامیک
    public function dynamicFields(): HasMany
    {
        return $this->hasMany(DynamicField::class);
    }

    public function children(): HasMany
    {
        return $this->hasMany(Category::class, 'parent_id')->with('children');
    }

    public function seoMetadata(): MorphOne
    {
        return $this->morphOne(SeoMetadata::class, 'seoable');
    }

    public function page()
    {
        return $this->hasOne(Page::class, 'slug', 'slug');
    }
}
