<?php

namespace App\Services\transaction;

use App\Models\Transaction;
use App\Models\WalletInternal;
use App\Models\Currency;
use Illuminate\Support\Facades\DB;

class WithdrawService
{
    public function processWithdraw(array $data, $user)
    {
        $currency = Currency::where('symbol', $data['symbol'])->first();

        if (!$currency) {
            return response()->json(['status' => 'error', 'message' => 'ارز یافت نشد.'], 404);
        }

        $type = $currency->type; // fiat یا crypto


         $requestedAmount = floatval($data['amount']);


          $minWithdraw = floatval($currency->min_withdraw ?? 0);
            if ($requestedAmount < $minWithdraw) {
             return response()->json([
             'status' => 'error',
             'message' => "حداقل مبلغ برداشت برای این ارز {$minWithdraw} است."
             ], 422);
              }
        // پیدا کردن کیف پول داخلی (walletinternal) مربوط به کاربر و ارز
        $wallet = WalletInternal::where('user_id', $user->id)
            ->where('currency_id', $currency->id)
            ->first();

        if (!$wallet) {
            return response()->json(['status' => 'error', 'message' => 'کیف پول یافت نشد.'], 404);
        }


        // محاسبه کارمزد برداشت
        if ($type === 'crypto') {
            $withdrawFee = floatval($currency->withdraw_fee); // عدد ثابت
            $totalAmount = $requestedAmount + $withdrawFee;
            $paymentSystem = 'blockchain';
        } else {
            // withdraw_fee درصد هست
            $withdrawFee = floatval($currency->withdraw_fee);
            $feeAmount = ($withdrawFee / 100) * $requestedAmount;
            $totalAmount = $requestedAmount + $feeAmount;
            $paymentSystem = 'shaba';
        }

        // بررسی موجودی کافی در کیف پول
        if ($wallet->balance < $totalAmount) {
            return response()->json(['status' => 'error', 'message' => 'موجودی کیف پول کافی نیست.'], 422);
        }

        // شروع تراکنش دیتابیس
        DB::beginTransaction();

        try {
            // کم کردن از موجودی اصلی و اضافه کردن به موجودی فریز شده
            $wallet->balance -= $totalAmount;
            $wallet->balance_frozen += $totalAmount;
            $wallet->save();

            $transactionData = [
                'wallet_id' => $wallet->id,
                'user_id' => $user->id,
                'transaction_type' => 'withdraw',
                'currency' => $currency->symbol,
                'type' => 'withdraw',
                'status' => 'pending',
                'amount' => $requestedAmount,
                'total_amount' => $totalAmount,
                'payment_system' => $paymentSystem,
                'description' => 'در انتظار تایید برداشت',
            ];

            if ($type === 'crypto') {
                $transactionData['wallet_address'] = $data['wallet_address'] ?? null;
                $transactionData['blockchain'] = $data['blockchain'] ?? null;
              } else {
            if (!empty($data['bank_account_id'])) {
                $transactionData['bank_account_id'] = $data['bank_account_id'];
              } else {
             // اگر مقدار موجود نیست می‌تونی اینجا خطا بدهی یا لاگ کنی
              return response()->json([
                'status' => 'error',
                'message' => 'حساب بانکی برای برداشت فیات الزامی است.'
              ], 422);
                    }
            }
            $transaction = Transaction::create($transactionData);

            DB::commit();

            return response()->json([
                'status' => 'success',
                'message' => 'درخواست برداشت ثبت شد.',
                'transaction_id' => $transaction->id,
            ]);

        } catch (\Exception $e) {
            DB::rollBack();

            return response()->json([
                'status' => 'error',
                'message' => 'خطا در ثبت درخواست برداشت: ' . $e->getMessage(),
            ], 500);
        }
    }
}
