<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSlidersTable extends Migration
{
    public function up()
    {
        Schema::create('sliders', function (Blueprint $table) {
            $table->id();
            $table->string('image');  // آدرس تصویر اسلایدر
            $table->string('title')->nullable();  // عنوان اسلایدر
            $table->text('description')->nullable();  // توضیحات اسلایدر
            $table->unsignedBigInteger('setting_id');  // ارتباط با Setting
            $table->string('slug')->unique();
            $table->foreign('setting_id')->references('id')->on('settings')->onDelete('cascade');
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('sliders');
    }
}
