<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePageFieldsTable extends Migration
{
    public function up()
    {
        Schema::create('page_fields', function (Blueprint $table) {
            $table->id();

            $table->foreignId('page_id')->constrained()->onDelete('cascade');

            $table->string('name');     // نام فیلد داینامیک
            $table->string('type');     // نوع فیلد مثل string, text, number, boolean, date و غیره

            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('page_fields');
    }
}

