<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Dashboard\transaction\TransactionReportController;
use App\Http\Controllers\Dashboard\transaction\DepositController;
use App\Http\Controllers\Dashboard\transaction\WithdrawController;
use App\Http\Middleware\ApiKeyRateLimit;

Route::middleware(ApiKeyRateLimit::class)->group(function () {
Route::prefix('dashboard/transactions')->group(function () {
     Route::middleware('auth:sanctum')->get('/', [TransactionReportController::class, 'index']); // همه تراکنش‌ها
     Route::middleware('auth:sanctum')->get('/wallet/{walletId}', [TransactionReportController::class, 'byWallet']); // بر اساس کیف پول
     Route::middleware('auth:sanctum')->get('/currency/{currency}', [TransactionReportController::class, 'byCurrency']); // بر اساس ارز
     Route::middleware('auth:sanctum')->post('/filter', [TransactionReportController::class, 'filter']); // فیلتر تراکنش‌ها
});
     Route::middleware('auth:sanctum')->post('dashboard/deposit', [DepositController::class, 'handle']); // فیلتر تراکنش‌ها
     Route::middleware('auth:sanctum')->post('dashboard/withdraw', [WithdrawController::class, 'handle']); // فیلتر تراکنش‌ها

});
Route::get('/payment/callback', [DepositController::class, 'callback'])->name('payment.callback');
