<?php

namespace App\Http\Controllers\Shared;

use App\Http\Controllers\Controller;
use App\Models\Category;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Jobs\UpdateCryptoPricesJob;
use GuzzleHttp\Client;
use Symfony\Component\DomCrawler\Crawler;
use Illuminate\Support\Facades\Http;
use App\Services\shared\category\CategoryService;
class CategoryController extends Controller
{
   public function tree(): JsonResponse
{
    $timestamp = now()->toIso8601String();
    $version = 'v1';

    // گرفتن دسته‌هایی که والد ندارند (یعنی parent_id == null)
    // به همراه بارگذاری eager رابطه children (زیرشاخه‌ها)
    $categories = Category::with('children')->whereNull('parent_id')->get();

    // اگر دسته‌بندی‌ها پیدا نشد
    if ($categories->isEmpty()) {
        return response()->json([
            'status' => 'error',
            'message' => 'دسته‌بندی‌ها یافت نشد.',
            'error' => [
                'code' => 'CATEGORIES_NOT_FOUND',
                'details' => 'هیچ دسته‌بندی بدون والد پیدا نشد.'
            ],
            'meta' => [
                'timestamp' => $timestamp,
                'version' => $version
            ]
        ], 404);
    }

    // در صورتی که دسته‌بندی‌ها پیدا شدند
    return response()->json([
        'status' => 'success',
        'message' => 'دسته‌بندی‌ها با موفقیت بارگذاری شدند.',
        'data' => $categories,
        'meta' => [
            'timestamp' => $timestamp,
            'version' => $version
        ]
    ]);
}


     public function show_cat($slug, CategoryService $categoryService)
{
    $timestamp = now()->toIso8601String();
    $version = 'v1';

    $data = $categoryService->getCategoryPageWithSeo($slug);

    if (!$data) {
        return response()->json([
            'status' => 'error',
            'message' => 'دسته‌بندی یافت نشد.',
            'error' => [
                'code' => 'CATEGORY_NOT_FOUND',
                'details' => "دسته‌بندی با اسلاگ '{$slug}' یافت نشد."
            ],
            'meta' => [
                'timestamp' => $timestamp,
                'version' => $version
            ]
        ], 404);
    }

    return response()->json([
        'status' => 'success',
        'message' => 'عملیات با موفقیت انجام شد.',
        'data' => $data,
        'meta' => [
            'timestamp' => $timestamp,
            'version' => $version
        ]
    ]);
}

    public function fetchRates()
       {
             $response = Http::get('https://call3.tgju.org/ajax.json?rev=yd1frebfcHWFyYjIhBUdNwoeOuCcSDrEFbdwpgsl9g2iJOo9XgtDOvRZGfT1'); // آدرس واقعی رو جایگزین کن
             $prices = $response->json();
             return $prices; // یا هر کاری که خواستی بکن
       }
}
