<?php

namespace App\Http\Controllers\Shared;

use App\Http\Controllers\Controller;
use App\Models\Category;
use App\Models\Item;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Jobs\UpdateCryptoPricesJob;
use GuzzleHttp\Client;
use Symfony\Component\DomCrawler\Crawler;
use Illuminate\Support\Facades\Http;
use App\Services\shared\item\ItemService;
    class ItemController extends Controller
     {

     protected $itemService;

    public function __construct(ItemService $itemService)
    {
        $this->itemService = $itemService;
    }

    public function show_item($slug): JsonResponse
{
    $timestamp = now()->toIso8601String();
    $version = 'v1';

    // گرفتن آیتم بر اساس اسلاگ
    $item = $this->itemService->getItemBySlug($slug);

    // اگر آیتم پیدا نشد
    if (!$item) {
        return response()->json([
            'status' => 'error',
            'message' => 'آیتم یافت نشد.',
            'error' => [
                'code' => 'ITEM_NOT_FOUND',
                'details' => 'آیتم با اسلاگ مشخص شده پیدا نشد.'
            ],
            'meta' => [
                'timestamp' => $timestamp,
                'version' => $version
            ]
        ], 404);
    }

    // در صورتی که آیتم پیدا شد
    return response()->json([
        'status' => 'success',
        'message' => 'آیتم با موفقیت بارگذاری شد.',
        'data' => $item,
        'meta' => [
            'timestamp' => $timestamp,
            'version' => $version
        ]
    ]);
}


 public function landing_Featured(): JsonResponse
{
    $timestamp = now()->toIso8601String();
    $version = 'v1';

    // گرفتن آیتم‌های ویژه
    $items = $this->itemService->getFeaturedItem();

    // اگر آیتم‌ها پیدا نشدند
    if ($items->isEmpty()) {
        return response()->json([
            'status' => 'error',
            'message' => 'آیتم‌های ویژه پیدا نشد.',
            'error' => [
                'code' => 'FEATURED_ITEMS_NOT_FOUND',
                'details' => 'هیچ آیتم ویژه‌ای برای نمایش وجود ندارد.'
            ],
            'meta' => [
                'timestamp' => $timestamp,
                'version' => $version
            ]
        ], 404);
    }

    // در صورتی که آیتم‌ها پیدا شدند
    return response()->json([
        'status' => 'success',
        'message' => 'آیتم‌های ویژه با موفقیت بارگذاری شدند.',
        'data' => $items,
        'meta' => [
            'timestamp' => $timestamp,
            'version' => $version
        ]
    ]);
}



    public function getProductsByCategorySlug(string $slug): JsonResponse
{
    $timestamp = now()->toIso8601String();
    $version = 'v1';

    // گرفتن محصولات بر اساس اسلاگ دسته‌بندی
    $products = $this->itemService->getProductsByCategorySlug($slug);

    // اگر محصولات پیدا نشدند
    if ($products->isEmpty()) {
        return response()->json([
            'status' => 'error',
            'message' => 'دسته‌بندی پیدا نشد یا محصولی موجود نیست.',
            'error' => [
                'code' => 'CATEGORY_NOT_FOUND',
                'details' => 'دسته‌بندی با اسلاگ مشخص شده پیدا نشد یا محصولی در آن وجود ندارد.'
            ],
            'meta' => [
                'timestamp' => $timestamp,
                'version' => $version
            ]
        ], 404);
    }

    // در صورتی که محصولات پیدا شدند
    return response()->json([
        'status' => 'success',
        'message' => 'محصولات دسته‌بندی با موفقیت بارگذاری شدند.',
        'data' => $products,
        'meta' => [
            'timestamp' => $timestamp,
            'version' => $version
        ]
    ]);
}

     }
