<?php

namespace App\Http\Controllers\dashboard\transaction;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Services\transaction\DepositService;
use App\Http\Requests\DepositRequest;
use App\Models\Transaction;
class DepositController extends Controller
{
    public function handle(DepositRequest $request, DepositService $service)
    {
        return $service->processDeposit($request->validated(), auth()->user());
    }

      public function callback(Request $request, DepositService $depositService)
{
    $timestamp = now()->toIso8601String();
    $version = 'v1';

    $trackId = $request->query('trackId');
    $success = $request->query('success');

    if (!$trackId) {
        return response()->json([
            'status' => 'error',
            'message' => 'شناسه تراکنش یافت نشد.',
            'meta' => [
                'timestamp' => $timestamp,
                'version' => $version
            ]
        ], 400);
    }

    // Verify payment status with Zibal
    $verify = $depositService->verifyPayment($trackId);

    // Find transaction by trackId stored in metadata JSON column
    $transaction = Transaction::where('metadata->trackId', $trackId)->first();

    if (!$transaction) {
        return response()->json([
            'status' => 'error',
            'message' => 'تراکنش یافت نشد.',
            'meta' => [
                'timestamp' => $timestamp,
                'version' => $version
            ]
        ], 404);
    }

    if ($verify['success'] && $verify['status'] == 1 && $success == 1) {
        // Payment successful
        $transaction->status = 'completed';
        $transaction->external_id = $verify['data']['refNumber'] ?? null;
        $transaction->description = $verify['data']['description'] ?? $transaction->description;
        $transaction->save();

        // Increase wallet balance
        $wallet = $transaction->wallet;
        if ($wallet) {
            $wallet->balance += $transaction->amount;
            $wallet->save();
        }

        return response()->json([
            'status' => 'success',
            'message' => 'پرداخت با موفقیت تکمیل شد.',
            'data' => $transaction,
            'meta' => [
                'timestamp' => $timestamp,
                'version' => $version
            ]
        ]);
    } else {
        // Payment failed or not verified
        $transaction->status = 'failed';
        $transaction->description = 'پرداخت ناموفق بوده یا لغو شده است.';
        $transaction->save();

        return response()->json([
            'status' => 'error',
            'message' => 'پرداخت ناموفق بوده یا لغو شده است.',
            'meta' => [
                'timestamp' => $timestamp,
                'version' => $version
            ]
        ], 400);
    }
}

}
