<?php

namespace App\Http\Controllers\dashboard\transaction;
use App\Http\Controllers\Controller;
use App\Services\transaction\TransactionReportService;
use Illuminate\Http\Request;

class TransactionReportController extends Controller
{
    protected $reportService;

    public function __construct(TransactionReportService $reportService)
    {
        $this->reportService = $reportService;
    }

        public function index()
{
    $timestamp = now()->toIso8601String();
    $version = 'v1';

    $transactions = $this->reportService->getAllTransactions();

    if ($transactions->isEmpty()) {
        return response()->json([
            'status' => 'error',
            'message' => 'هیچ تراکنشی یافت نشد.',
            'error' => [
                'code' => 'NO_TRANSACTIONS',
                'details' => 'هیچ تراکنشی در پایگاه داده موجود نیست.'
            ],
            'meta' => [
                'timestamp' => $timestamp,
                'version' => $version
            ]
        ], 404);
    }

    return response()->json([
        'status' => 'success',
        'message' => 'لیست تمام تراکنش‌ها با موفقیت بارگذاری شد.',
        'data' => $transactions,
        'meta' => [
            'timestamp' => $timestamp,
            'version' => $version
        ]
    ]);
}

// 2- لیست تراکنش‌ها بر اساس wallet_id
public function byWallet($walletId)
{
    $timestamp = now()->toIso8601String();
    $version = 'v1';

    $transactions = $this->reportService->getTransactionsByWalletId($walletId);

    if ($transactions->isEmpty()) {
        return response()->json([
            'status' => 'error',
            'message' => 'هیچ تراکنشی برای این wallet_id پیدا نشد.',
            'error' => [
                'code' => 'NO_TRANSACTIONS_FOUND',
                'details' => 'لطفا wallet_id معتبر وارد کنید.'
            ],
            'meta' => [
                'timestamp' => $timestamp,
                'version' => $version
            ]
        ], 404);
    }

    return response()->json([
        'status' => 'success',
        'message' => 'لیست تراکنش‌ها برای wallet_id: ' . $walletId . ' با موفقیت بارگذاری شد.',
        'data' => $transactions,
        'meta' => [
            'timestamp' => $timestamp,
            'version' => $version
        ]
    ]);
}

// 3- لیست تراکنش‌ها بر اساس ارز
public function byCurrency($currency)
{
    $timestamp = now()->toIso8601String();
    $version = 'v1';

    $transactions = $this->reportService->getTransactionsByCurrency($currency);

    if ($transactions->isEmpty()) {
        return response()->json([
            'status' => 'error',
            'message' => 'هیچ تراکنشی برای این ارز پیدا نشد.',
            'error' => [
                'code' => 'NO_TRANSACTIONS_FOR_CURRENCY',
                'details' => 'لطفا ارز معتبر وارد کنید.'
            ],
            'meta' => [
                'timestamp' => $timestamp,
                'version' => $version
            ]
        ], 404);
    }

    return response()->json([
        'status' => 'success',
        'message' => 'لیست تراکنش‌ها برای ارز: ' . $currency . ' با موفقیت بارگذاری شد.',
        'data' => $transactions,
        'meta' => [
            'timestamp' => $timestamp,
            'version' => $version
        ]
    ]);
}

// 4- فیلتر تراکنش‌ها
public function filter(Request $request)
{
    $timestamp = now()->toIso8601String();
    $version = 'v1';

    $filters = $request->only(['currency', 'transaction_type', 'date_from', 'date_to']);

    if (empty($filters)) {
        return response()->json([
            'status' => 'error',
            'message' => 'فیلترهای معتبر وارد نشده‌اند.',
            'error' => [
                'code' => 'INVALID_FILTERS',
                'details' => 'لطفا حداقل یکی از فیلترها را وارد کنید.'
            ],
            'meta' => [
                'timestamp' => $timestamp,
                'version' => $version
            ]
        ], 400);
    }

    $transactions = $this->reportService->filterTransactions($filters);

    return response()->json([
        'status' => 'success',
        'message' => 'تراکنش‌ها با فیلترهای ارائه‌شده با موفقیت بارگذاری شدند.',
        'data' => $transactions,
        'meta' => [
            'timestamp' => $timestamp,
            'version' => $version
        ]
    ]);
}


}
