<?php

namespace App\Http\Controllers\dashboard\transaction;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\WithdrawRequest;
use App\Services\transaction\WithdrawService;

class WithdrawController extends Controller
{
    protected $withdrawService;

    public function __construct(WithdrawService $withdrawService)
    {
        $this->withdrawService = $withdrawService;
    }

    public function handle(WithdrawRequest $request)
    {
        $user = auth()->user();
        return $this->withdrawService->processWithdraw($request->validated(), $user);
    }
}

