<?php

namespace App\Http\Controllers\dashboard\user;

use App\Http\Controllers\Controller;
use App\Http\Requests\UpdateUserProfileRequest;
use App\Services\user\UserProfileService;
use App\Services\user\UserLoginService;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\JsonResponse;

class UserProfileController extends Controller
{
    protected $userProfileService;
     protected $userLoginService;

    public function __construct(UserProfileService $userProfileService,UserLoginService $userLoginService)
    {
        $this->userProfileService = $userProfileService;
        $this->userLoginService = $userLoginService;
    }

     public function update(UpdateUserProfileRequest $request): JsonResponse
{
    $timestamp = now()->toIso8601String();
    $version = 'v1';

    $user = Auth::user();

    $data = $request->validated();

    $result = $this->userProfileService->updateProfile($user->id, $data);

    if ($result['status'] === 'error') {
        return response()->json([
            'status' => 'error',
            'message' => $result['message'],
            'error' => [
                'code' => 'PROFILE_UPDATE_FAILED',
                'details' => 'مشکلی در به‌روزرسانی پروفایل ایجاد شده است.'
            ],
            'meta' => [
                'timestamp' => $timestamp,
                'version' => $version
            ]
        ], 422);
    }

    return response()->json([
        'status' => 'success',
        'message' => $result['message'],
        'data' => $result['data'],
        'meta' => [
            'timestamp' => $timestamp,
            'version' => $version
        ]
    ]);
}


public function loginLists()
{
    $timestamp = now()->toIso8601String();
    $version = 'v1';

    $user = Auth::user();
    $logins = $this->userLoginService->getUserLogins($user->id);

    if ($logins->isEmpty()) {
        return response()->json([
            'status' => 'error',
            'message' => 'هیچ لاگینی یافت نشد.',
            'error' => [
                'code' => 'NO_LOGINS_FOUND',
                'details' => 'هیچ لاگینی برای این کاربر ثبت نشده است.'
            ],
            'meta' => [
                'timestamp' => $timestamp,
                'version' => $version
            ]
        ], 404);
    }

    return response()->json([
        'status' => 'success',
        'message' => 'لیست لاگین‌های کاربر با موفقیت بارگذاری شد.',
        'data' => $logins,
        'meta' => [
            'timestamp' => $timestamp,
            'version' => $version
        ]
    ]);
}

public function logoutOthers(Request $request)
{
    $timestamp = now()->toIso8601String();
    $version = 'v1';

    $user = Auth::user();

    $currentLoginId = $request->input('current_login_id');
    if (!$currentLoginId) {
        return response()->json([
            'status' => 'error',
            'message' => 'شناسه لاگین فعلی ارسال نشده.',
            'error' => [
                'code' => 'MISSING_CURRENT_LOGIN_ID',
                'details' => 'لطفا شناسه لاگین فعلی را ارسال کنید.'
            ],
            'meta' => [
                'timestamp' => $timestamp,
                'version' => $version
            ]
        ], 422);
    }

    $this->userLoginService->logoutOtherDevices($user->id, $currentLoginId);

    return response()->json([
        'status' => 'success',
        'message' => 'دستگاه‌های دیگر با موفقیت خارج شدند.',
        'meta' => [
            'timestamp' => $timestamp,
            'version' => $version
        ]
    ]);
}

}
