<?php

namespace App\Http\Controllers\Dashboard\Verify;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Http\Controllers\Controller;
use App\Models\UserVerification;
use Illuminate\Support\Facades\Auth;
use App\Services\verify\ZibalService;
use App\Models\User;
use App\Http\Requests\VerifyUserRequest;
use App\Services\verify\VerifyUserService;
class VerifyController extends Controller
{
    protected $zibalService;
    protected $verifyUserService;


    public function __construct(VerifyUserService $verifyUserService)
    {
        $this->verifyUserService = $verifyUserService;
    }

   public function verifyUser(VerifyUserRequest $request)
{
    $timestamp = now()->toIso8601String();
    $version = 'v1';

    $user = Auth::user();

    if (!$user) {
        return response()->json([
            'status' => 'error',
            'message' => 'Unauthorized',
            'error' => [
                'code' => 'UNAUTHORIZED',
                'details' => 'لطفا وارد حساب کاربری خود شوید.'
            ],
            'meta' => [
                'timestamp' => $timestamp,
                'version' => $version
            ]
        ], 401);
    }

    $result = $this->verifyUserService->verify($user->id);

    if ($result['status'] === 'error') {
        return response()->json([
            'status' => 'error',
            'message' => $result['message'],
            'error' => [
                'code' => 'USER_VERIFICATION_FAILED',
                'details' => 'تایید کاربر با مشکل مواجه شد.'
            ],
            'meta' => [
                'timestamp' => $timestamp,
                'version' => $version
            ]
        ], 400);
    }

    return response()->json([
        'status' => 'success',
        'message' => $result['message'],
        'meta' => [
            'timestamp' => $timestamp,
            'version' => $version
        ]
    ]);
}

}
