<?php

namespace App\Http\Controllers\Auth;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Http\Controllers\Controller;
use App\Models\User;
use App\Services\sms\SmsFarazService;
use App\Services\auth\OtpService;
use App\Http\Requests\SendOtpRequest;
use App\Http\Requests\VerifyOtpRequest;
use Jenssegers\Agent\Agent;
class AuthController extends Controller
{
    protected $otpService;

    // سازنده برای تزریق سرویس
    public function __construct(OtpService $otpService)
    {
        $this->otpService = $otpService;
    }
       // ارسال کد یکبار مصرف به موبایل
       public function sendOtp(SendOtpRequest $request, OtpService $otpService)
       {
           // چون ولیدیشن انجام شده، مستقیم می‌ریم سراغ پردازش
           $mobile = $request->input('mobile');

           $user = User::firstOrCreate(['mobile' => $mobile], ['is_active' => true]);

           $response = $otpService->generateAndSendOtp($user);

           if ($response->successful()) {
               return response()->json([
                   'status' => 'success',
                   'message' => 'کد تایید ارسال شد'
               ]);
           } else {
               return response()->json([
                   'status' => 'error',
                   'message' => 'خطا در ارسال پیامک، لطفا بعدا تلاش کنید',
                   'details' => $response->body()
               ], 500);
           }
       }
       public function verifyOtp(VerifyOtpRequest $request)
       {
           $result = $this->otpService->verifyOtp($request->mobile, $request->otp_code);

           if ($result['status'] === 'error') {
               return response()->json(['error' => $result['message']], $result['code']);
           }
            // ایجاد رخداد لاگین
            $user = User::where('mobile', $request->mobile)->first();

           if (!$user) {
              return response()->json(['error' => 'کاربر یافت نشد.'], 404);
           }
           $agent = new Agent();

           $user->logins()->create([
                 'ip_address' => $request->ip(),
                 'user_agent' => $request->userAgent(),
                 'device' => $agent->device(),
                 'platform' => $agent->platform(),
                 'is_current' => true,
                 'last_active_at' => now(),
           ]);
           return response()->json([
               'status' => 'success',
               'message' => $result['message'],
               'access_token' => $result['access_token'],
               'token_type' => $result['token_type'],
           ]);
       }


       public function checkAuth(Request $request)
      {
            return response()->json([
              'status' => 'success',
              'authenticated' => true,
              'user' => $request->user()
            ]);
      }

       public function logout(Request $request)
      {
         // حذف توکن فعلی که فرانت‌اند ارسال کرده
         $request->user()->currentAccessToken()->delete();

          return response()->json([
            'status' => 'success',
            'message' => 'خروج با موفقیت انجام شد'
          ]);
      }
   }
