<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class UpdateUserProfileRequest extends FormRequest
{
    public function authorize()
    {
        // بررسی user_level
        return Auth::check() && Auth::user()->user_level === 0;
    }

    public function rules()
    {
        return [
            'first_name' => 'required|string|max:255',
            'last_name' => 'required|string|max:255',
            'email' => 'required|email|unique:users,email,' . Auth::id(),
            'birthdate' => 'required|date',
            'national_code' => 'required|string|max:10',
            'postal_code' => 'required|string|max:10',
            'country' => 'required|string|max:255',
            'city' => 'required|string|max:255',
            'address' => 'required|string|max:500',
        ];
    }

      public function messages()
    {
        return [
            'first_name.required' => 'نام باید وارد شود.',
            'first_name.string' => 'نام باید متن باشد.',
            'first_name.max' => 'نام نباید بیشتر از ۲۵۵ کاراکتر باشد.',

            'last_name.required' => 'نام خانوادگی باید وارد شود.',
            'last_name.string' => 'نام خانوادگی باید متن باشد.',
            'last_name.max' => 'نام خانوادگی نباید بیشتر از ۲۵۵ کاراکتر باشد.',

            'email.required' => 'ایمیل باید وارد شود.',
            'email.email' => 'ایمیل وارد شده معتبر نیست.',
            'email.unique' => 'این ایمیل قبلا ثبت شده است.',

            'birthdate.required' => 'تاریخ تولد باید وارد شود.',
            'birthdate.date' => 'فرمت تاریخ تولد صحیح نیست.',

            'national_code.required' => 'کد ملی باید وارد شود.',
            'national_code.string' => 'کد ملی باید متن باشد.',
            'national_code.max' => 'کد ملی نباید بیشتر از ۱۰ کاراکتر باشد.',

            'country.required' => 'کشور باید وارد شود.',
            'country.string' => 'کشور باید متن باشد.',
            'country.max' => 'کشور نباید بیشتر از ۲۵۵ کاراکتر باشد.',

            'city.required' => 'شهر باید وارد شود.',
            'city.string' => 'شهر باید متن باشد.',
            'city.max' => 'شهر نباید بیش از ۲۵۵ کاراکتر باشد',

            'postal_code.required' => 'کد پستی باید وارد شود.',
            'postal_code.string' => 'کد پستی باید متن باشد.',
            'postal_code.max' => 'کد پستی نباید بیشتر از ۱۰ کاراکتر باشد.',

            'address.required' => 'آدرس باید وارد شود.',
            'address.string' => 'آدرس باید متن باشد.',
            'address.max' => 'آدرس نباید بیشتر از ۵۰۰ کاراکتر باشد.',

            'authorize' => 'شما اجازه تغییر اطلاعات را ندارید.',
        ];
    }

        protected function failedValidation(\Illuminate\Contracts\Validation\Validator $validator)
    {
        throw new \Illuminate\Validation\ValidationException($validator, response()->json([
            'status' => 'error',
            'errors' => $validator->errors()
        ], 422));
    }
}

