<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use App\Models\Currency;

class WithdrawRequest extends FormRequest
{
    protected $symbol;

    protected function prepareForValidation(): void
    {
        // گرفتن symbol از ورودی
        $this->symbol = $this->input('symbol');
    }

    public function rules(): array
    {
        $rules = [
            'symbol' => ['required', 'string', 'exists:currencies,symbol'],
            'amount' => ['required', 'numeric'],
        ];

        if ($this->symbol) {
            $currency = Currency::where('symbol', $this->symbol)->first();

            if ($currency && $currency->type === 'crypto') {
                $rules['wallet_address'] = ['required', 'string'];
                $rules['blockchain'] = ['required', 'string'];
            }

            if ($currency && $currency->type === 'fiat') {
                $rules['bank_account_id'] = ['required', 'integer', 'exists:bank_accounts,id'];
            }
        }

        return $rules;
    }

    public function messages(): array
    {
        return [
            'symbol.required' => 'نماد ارز الزامی است.',
            'symbol.exists' => 'ارز یافت نشد.',
            'amount.required' => 'مبلغ برداشت الزامی است.',
            'amount.numeric' => 'مبلغ باید عددی باشد.',
            'wallet_address.required' => 'آدرس کیف پول برای رمز ارز الزامی است.',
            'blockchain.required' => 'بلاکچین برای رمز ارز الزامی است.',
            'bank_account_id.required' => 'حساب بانکی برای فیات الزامی است.',
            'bank_account_id.exists' => 'حساب بانکی معتبر نیست.',
        ];
    }

    protected function failedValidation(\Illuminate\Contracts\Validation\Validator $validator)
    {
        throw new \Illuminate\Validation\ValidationException($validator, response()->json([
            'status' => 'error',
            'errors' => $validator->errors()
        ], 422));
    }
}
