<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class DynamicField extends Model
{
    protected $fillable = [
        'name',
        'slug',
        'description',
        'field_type',
        'options',
        'category_id',
        'parent_id',
        'is_active',
        'sort_order',
    ];


    protected $casts = [
        'options' => 'array',
        'is_active' => 'boolean',
    ];

    public function category(): BelongsTo
    {
        return $this->belongsTo(Category::class);
    }

    public function subcategory(): BelongsTo
    {
        return $this->belongsTo(Subcategory::class);
    }
}
