<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;
use App\Models\BankAccount;
use Illuminate\Support\Facades\Auth;

class ValidUserBankAccount implements Rule
{
    public function passes($attribute, $value): bool
    {
        return BankAccount::where('id', $value)
            ->where('user_id', Auth::id())
            ->where('status','active')
            ->exists();
    }

    public function message(): string
    {
        return 'حساب بانکی معتبر نیست یا متعلق به شما نیست.';
    }
}
