<?php

namespace App\Services\ticket;

use App\Models\Ticket;
use App\Models\TicketReply;
use Illuminate\Support\Facades\DB;

class TicketReplyService
{
    /**
     * ذخیره پاسخ تیکت با امکان پیوست فایل
     *
     * @param int $userId
     * @param array $data
     * @param array|null $attachments
     * @return TicketReply
     */
    public function createReply(int $userId, array $data, ?array $attachments = null): TicketReply
    {
        return DB::transaction(function () use ($userId, $data, $attachments) {
            $reply = TicketReply::create([
                'ticket_id' => $data['ticket_id'],
                'user_id' => $userId,
                'message' => $data['message'],
            ]);
            $changeStaus = Ticket::Where('id',$data['ticket_id'])->update([
               'status' => 'user_replied'
            ]);
            if ($attachments) {
                foreach ($attachments as $file) {
                    $path = $file->store('ticket_attachments');

                    $reply->attachments()->create([
                        'file_path' => $path,
                        'file_name' => $file->getClientOriginalName(),
                        'mime_type' => $file->getClientMimeType(),
                        'file_size' => $file->getSize(),
                    ]);
                }
            }

            return $reply;
        });
    }
}
