<?php

// database/migrations/2025_05_23_000003_create_tickets_table.php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTicketsTable extends Migration
{
    public function up()
    {
        Schema::create('tickets', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('user_id');          // کاربر ایجاد کننده تیکت
            $table->unsignedBigInteger('assigned_to')->nullable();  // پشتیبان یا مدیر مسئول پاسخگویی
            $table->unsignedBigInteger('department_id');    // دپارتمان مرتبط

            $table->unsignedBigInteger('priority_id');      // اولویت

            $table->string('subject');
            $table->text('description')->nullable();

            // وضعیت‌ها: new, user_replied, support_replied, closed
            $table->enum('status', ['new', 'user_replied', 'support_replied', 'closed'])->default('new');

            $table->timestamps();

            // foreign keys
            $table->foreign('user_id')->references('id')->on('users')->cascadeOnDelete();
            $table->foreign('assigned_to')->references('id')->on('users')->nullOnDelete();
            $table->foreign('department_id')->references('id')->on('ticket_departments')->cascadeOnDelete();
            $table->foreign('priority_id')->references('id')->on('ticket_priorities')->cascadeOnDelete();
        });
    }

    public function down()
    {
        Schema::dropIfExists('tickets');
    }
};

