<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePageFieldValuesTable extends Migration
{
    public function up()
    {
        Schema::create('page_field_values', function (Blueprint $table) {
            $table->id();

            $table->foreignId('page_field_id')->constrained()->onDelete('cascade');
            $table->foreignId('page_id')->constrained()->onDelete('cascade');

            $table->text('value')->nullable();

            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('page_field_values');
    }
}

