<?php

namespace App\Http\Controllers\Shared;

use App\Http\Controllers\Controller;
use App\Models\Category;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Jobs\UpdateCryptoPricesJob;

class CategoryController extends Controller
{
    public function tree(): JsonResponse
       {
            // گرفتن دسته‌هایی که والد ندارند (یعنی parent_id == null)
           // به همراه بارگذاری eager رابطه children (زیرشاخه‌ها)
           $categories = Category::with('children')->whereNull('parent_id')->get();

           return response()->json($categories);
       }
}
