<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Models\User;
use Laravel\Sanctum\PersonalAccessToken;
use Illuminate\Support\Facades\Log;

class CheckUserLevel
{
    public function handle(Request $request, Closure $next, $minLevel = 1)
    {
        $authHeader = $request->header('Authorization');

        if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
            return response()->json(['status' => 'error', 'message' => 'توکن احراز هویت ارسال نشده است.'], 401);
        }

        $token = $matches[1];

        Log::info('Checking Token:', ['token' => $token]);

        // بررسی اعتبار توکن و استخراج کاربر با Sanctum
        $accessToken = PersonalAccessToken::findToken($token);

        if (!$accessToken) {
            Log::error('Token Error: توکن معتبر نیست یا کاربر یافت نشد.', ['token' => $token]);
            return response()->json(['status' => 'error', 'message' => 'توکن معتبر نیست یا کاربر یافت نشد.'], 401);
        }

        // یافتن کاربر از طریق شناسه مرتبط با توکن
        $user = $accessToken->tokenable;

        // بررسی سطح کاربری کاربر
        if ($user->user_level < (int) $minLevel) {
            return response()->json(['status' => 'error', 'message' => 'دسترسی کافی ندارید.'], 403);
        }

        // اضافه کردن کاربر به درخواست برای استفاده در کنترلر
        $request->attributes->add(['user' => $user]);

        return $next($request);
    }
}
