<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class BankAccountRequest extends FormRequest
{
    public function authorize()
    {
        return true; // بررسی لاگین شدن را انجام نمی‌دهد.
    }

    public function rules()
    {
        return [
            'user_id' => ['required', 'integer'],
            'currency_type' => ['required', 'string'],
            'card_number' => ['nullable', 'string'],
            'iban' => ['nullable', 'string'],
            'bank_name' => ['nullable', 'string'],
            'account_holder_name' => ['nullable', 'string'],
        ];
    }

    public function messages()
    {
        return [
            'user_id.required' => 'شناسه کاربر الزامی است.',
            'currency_type.required' => 'نوع ارز الزامی است.',
        ];
    }

    // جلوگیری از ریدایرکت به لاگین
    protected function failedValidation(\Illuminate\Contracts\Validation\Validator $validator)
    {
        throw new \Illuminate\Validation\ValidationException($validator, response()->json([
            'status' => 'error',
            'errors' => $validator->errors()
        ], 422));
    }
}
