<?php
namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class TicketReplyStoreRequest extends FormRequest
{
    public function authorize(): bool
    {
        // اگر لازم است می‌توانید احراز هویت پیچیده‌تر اضافه کنید
        return auth()->check();
    }

    public function rules(): array
    {
        return [
            'ticket_id' => ['required', 'integer', 'exists:tickets,id'],
            'message' => ['required', 'string'],
            'attachments.*' => ['file', 'max:10240'], // حداکثر 10 مگابایت برای هر فایل
        ];
    }

    public function messages(): array
    {
        return [
            'ticket_id.required' => 'شناسه تیکت لازم است.',
            'ticket_id.exists' => 'تیکت انتخاب شده معتبر نیست.',
            'message.required' => 'پیام پاسخ نمی‌تواند خالی باشد.',
            'attachments.*.file' => 'هر پیوست باید یک فایل معتبر باشد.',
            'attachments.*.max' => 'حداکثر حجم هر فایل 10 مگابایت است.',
        ];
    }

     protected function failedValidation(\Illuminate\Contracts\Validation\Validator $validator)
    {
        throw new \Illuminate\Validation\ValidationException($validator, response()->json([
            'status' => 'error',
            'errors' => $validator->errors()
        ], 422));
    }
}
