<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTransactionsTable extends Migration
{
    public function up()
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->id();

            $table->foreignId('wallet_id')->constrained()->onDelete('cascade');

            $table->enum('type', ['deposit', 'withdraw', 'transfer', 'exchange']);
            $table->decimal('amount', 30, 18);
            $table->decimal('amount_usd', 30, 18)->nullable();

            $table->enum('status', ['pending', 'completed', 'failed'])->default('pending');

            $table->string('transaction_hash')->nullable();
            $table->string('reference_id')->nullable();
            $table->text('details')->nullable();

            $table->timestamps();

            $table->index('status');
        });
    }

    public function down()
    {
        Schema::dropIfExists('transactions');
    }
}
